document.querySelector('form').addEventListener('submit', async (e) => {
    e.preventDefault();

    const email = document.querySelector('input[placeholder="Email"]').value;
    const password = document.querySelector('#password').value;

    const data = { email, password };

    try {
        const response = await fetch('http://localhost/backend/users/login.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
            body: JSON.stringify(data),
        });

        const result = await response.json();

        if (result.success) {
            alert('Login successful!');
            // Store the token (e.g., in localStorage)
            localStorage.setItem('token', result.token);
            // Redirect to a dashboard or home page
            window.location.href = 'dashboard.html'; // Adjust as needed
        } else {
            alert(result.message);
        }
    } catch (error) {
        alert('An error occurred: ' + error.message);
    }
});